<?php
include 'conexao.php';
session_start();

// Lógica para adicionar uma nova atribuição
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['remover_atribuicao_id'])) {
    $professor_id = $_POST['professor_id'];
    $disciplina_id = $_POST['disciplina_id'];

    // Buscar o turma_id da disciplina
    $stmt = $conn->prepare("SELECT turma_id FROM disciplinas WHERE id = ?");
    $stmt->bind_param("i", $disciplina_id);
    $stmt->execute();
    $stmt->bind_result($turma_id);
    $stmt->fetch();
    $stmt->close();

    if ($turma_id) {
        // Verificar duplicidade
        $verificar = $conn->prepare("SELECT id FROM atribuicoes WHERE disciplina_id = ? AND turma_id = ?");
        $verificar->bind_param("ii", $disciplina_id, $turma_id);
        $verificar->execute();
        $verificar->store_result();

        if ($verificar->num_rows > 0) {
            echo "<script>alert('Essa disciplina já foi atribuída para esta turma!');</script>";
        } else {
            // Inserir atribuição
            $sql = "INSERT INTO atribuicoes (professor_id, disciplina_id, turma_id) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iii", $professor_id, $disciplina_id, $turma_id);
            $stmt->execute();
            $stmt->close();
        }

        $verificar->close();
    }
}

// Lógica para remover uma atribuição
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['remover_atribuicao_id'])) {
    $atribuicao_id = $_POST['remover_atribuicao_id'];
    $sql_delete = "DELETE FROM atribuicoes WHERE id = ?";
    $stmt_delete = $conn->prepare($sql_delete);
    $stmt_delete->bind_param("i", $atribuicao_id);

    if ($stmt_delete->execute()) {
        echo "<script>alert('Atribuição removida com sucesso!');</script>";
        header("Location: " . $_SERVER['PHP_SELF']); // Redireciona para evitar reenvio do formulário
        exit();
    } else {
        echo "<script>alert('Erro ao remover a atribuição: " . $conn->error . "');</script>";
    }
    $stmt_delete->close();
}


// Buscar professores (perfil = 'Professor')
$professores = $conn->query("SELECT id, nome FROM usuarios WHERE perfil = 'Professor' ORDER BY nome");

// Buscar disciplinas + dados da turma
$disciplinas = $conn->query("
    SELECT 
        d.id AS disciplina_id,
        d.nome AS nome_disciplina,
        t.id AS turma_id,
        t.nome AS nome_turma,
        t.classe,
        t.curso,
        t.turno,
        t.sala
    FROM disciplinas d
    JOIN turmas t ON d.turma_id = t.id
    ORDER BY d.nome
");

// Buscar atribuições feitas
$atribuidas = $conn->query("
    SELECT 
        a.id,
        u.nome AS nome_professor,
        d.nome AS nome_disciplina,
        t.nome AS nome_turma,
        t.classe,
        t.curso,
        t.turno,
        t.sala
    FROM atribuicoes a
    JOIN usuarios u ON a.professor_id = u.id
    JOIN disciplinas d ON a.disciplina_id = d.id
    JOIN turmas t ON a.turma_id = t.id
    ORDER BY u.nome
");
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Atribuir Disciplina</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f6f8;
            padding: 20px;
        }
        h2 {
            text-align: center;
            color: #003366;
        }
        form {
            margin-bottom: 30px;
            background: #fff;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            max-width: 600px;
            margin: auto;
        }
        label {
            display: block;
            margin-bottom: 5px;
            color: #333;
        }
        select {
            width: 100%;
            padding: 8px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 6px;
        }
        .btn-atribuir {
            background-color: #0066cc;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        .btn-atribuir:hover {
            background-color: #004999;
        }
        .btn-remover {
            background-color: #dc3545;
            color: white;
            padding: 6px 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .btn-remover:hover {
            background-color: #c82333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #003366;
            color: white;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>

    <h2>Atribuir Disciplina a Professor</h2>

    <form method="POST">
        <label for="professor_id">Professor:</label>
        <select name="professor_id" id="professor_id" required>
            <option value="">-- Selecione --</option>
            <?php while ($prof = $professores->fetch_assoc()): ?>
                <option value="<?= $prof['id'] ?>"><?= htmlspecialchars($prof['nome']) ?></option>
            <?php endwhile; ?>
        </select>

        <label for="disciplina_id">Disciplina:</label>
        <select name="disciplina_id" id="disciplina_id" required>
            <option value="">-- Selecione --</option>
            <?php while ($d = $disciplinas->fetch_assoc()): ?>
                <option value="<?= $d['disciplina_id'] ?>">
                    <?= htmlspecialchars($d['nome_disciplina']) ?> - <?= $d['nome_turma'] ?> <?= $d['classe'] ?> <?= $d['curso'] ?> <?= $d['turno'] ?> (Sala <?= $d['sala'] ?>)
                </option>
            <?php endwhile; ?>
        </select>

        <button type="submit" class="btn-atribuir">Atribuir</button>
    </form>

    <h2>Disciplinas Atribuídas</h2>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Professor</th>
                <th>Disciplina</th>
                <th>Turma</th>
                <th>Classe</th>
                <th>Curso</th>
                <th>Turno</th>
                <th>Sala</th>
                <th>Ação</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($a = $atribuidas->fetch_assoc()): ?>
                <tr>
                    <td><?= $a['id'] ?></td>
                    <td><?= htmlspecialchars($a['nome_professor']) ?></td>
                    <td><?= htmlspecialchars($a['nome_disciplina']) ?></td>
                    <td><?= htmlspecialchars($a['nome_turma']) ?></td>
                    <td><?= htmlspecialchars($a['classe']) ?></td>
                    <td><?= htmlspecialchars($a['curso']) ?></td>
                    <td><?= htmlspecialchars($a['turno']) ?></td>
                    <td><?= htmlspecialchars($a['sala']) ?></td>
                    <td>
                        <form method="POST" action="">
                            <input type="hidden" name="remover_atribuicao_id" value="<?= $a['id'] ?>">
                            <button type="submit" class="btn-remover">Remover</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

</body>
</html>